#include <stdio.h>
#include <stdlib.h>

typedef struct {
    int index;
    long long w;
    long long v;
    double ratio;
} Poncho;

int cmp(const void *a, const void *b) {
    Poncho *pa = (Poncho *)a;
    Poncho *pb = (Poncho *)b;
    if (pa->ratio < pb->ratio) return 1;
    if (pa->ratio > pb->ratio) return -1;
    return 0;
}

int main() {
    int N;
    long long W;
    double eps;
    scanf("%d %lld %lf", &N, &W, &eps);

    Poncho ponchos[N];
    for (int i = 0; i < N; i++) {
        long long w, v;
        scanf("%lld %lld", &w, &v);
        ponchos[i].index = i + 1; // ??????? ?? 1
        ponchos[i].w = w;
        ponchos[i].v = v;
        ponchos[i].ratio = (double)v / w;
    }

    // ????????? ?? ?????? v/w
    qsort(ponchos, N, sizeof(Poncho), cmp);

    long long totalW = 0;
    int chosen[N];
    int cnt = 0;

    for (int i = 0; i < N; i++) {
        if (totalW + ponchos[i].w <= W) {
            totalW += ponchos[i].w;
            chosen[cnt++] = ponchos[i].index;
        }
    }

    printf("%d\n", cnt);
    for (int i = 0; i < cnt; i++) {
        printf("%d%c", chosen[i], (i == cnt-1) ? '\n' : ' ');
    }

    return 0;
}